
markup.push({

	// MARK: model

	AutomationModel:
	{
		nsClass: "AH4Automation",
	},

	
	// MARK: list item

	AutomationListItem:
	{
		nsClass: "GXListItemView",
		gxViewName: "automation",
		gxSelectable: 2, // multiselect
		axRoleDescription: "Automation",
		axTitleKeyPath: "accessibilityDescription",
		axHelp: "An automation runs a script on an event. Interact for settings",
		axIsIgnored: false,
		gxBackPainter: "ListItemBack",
		gxLateLayout:
		[
			"V:|-(-999)-[self(82)]",		// vertical position set by parent
			"H:|-10-[self]-2-|",
			
			"H:|-10-[eventLabel(==scriptLabel)]-6-[eventMenu]-12-[enabledSwitch(52)]-10-|&alignBaseline",
			"H:|-10-[scriptLabel(==eventLabel)]-6-[scriptMenu]-6-[revealBtn(16)]-10-|&alignBaseline",
			
			"V:|-11-[eventMenu]-12-[scriptMenu]",
			"V:[revealBtn(20)]",
		],
		gxChildViews:
		{
			eventLabel: labelView("Event:"),
			eventMenu: {
				"+": "PopupMenuTemplate.listBack",
				//gxMenuItemsKeyPath: "eventMenuItems",
				gxHideOnNilValue : false,
				axTitle: "Event",
				axHelp: "Select an event for which this automation will run",
				gxMenuItems:
				[
					menuItem("Recording Stop", "fileDidEnd"),
					menuItem("Session Start", "sessionWillStart"),
					menuItem("Session Stop", "sessionDidStop"),
					//menuItem("Repeat While Running", "onIdle"),
					menuItem("Timer Start", "timerWillStart"),
					menuItem("Timer Stop", "timerDidStop"),
				],
			},
			enabledSwitch: {
				"+": "SwitchView.noBlockDisabled",
				gxBaselineOffset: 7,
				axTitle: "Enabled",
				axHelp: "When on, this action will run. When off, it is ignored",
			},
			scriptLabel: labelView("Run:"),
			scriptMenu: {
				"+": "PopupMenuTemplate.listBack",
				gxHideOnNilValue : false,
				axTitle: "Script",
				axHelp: "Select a script for this automation to run",
				gxMenuItemsKeyPath: "scriptMenuItems",
			},
			revealBtn: {
				"+": "ImageButtonView.foreColor1.loupe",
				gxValueKey: "revealBtn",
				gxDisableOnNil: true,
				axTitle: "Reveal Script",
				axTitle: "Reveals the selected script in the Script Library window",
			},
		}
	},

})




